using System;
using System.ComponentModel;
using System.Collections;
using Borland.Eco.Services;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.ObjectImplementation;
using Borland.Eco.UmlRt;
using Borland.Eco.UmlCodeAttributes;


namespace SimpleEcoWebDemo
{
	[UmlElement("Package", Id="14bf564d-9918-4275-9a80-9814e7649025")]
	[UmlMetaAttribute("ownedElement", typeof(Order))]
	[UmlMetaAttribute("ownedElement", typeof(OrderItem))]
	[EcoCodeGenVersion("2.0")]
	public abstract class CoreClassesPackage
	{
        
        [UmlElement("Association", Id="0799d598-7d51-4e6d-9701-c199ab8827b1")]
		public class Association_1
		{
		}
	}
    [UmlElement(Id="00bb9996-b420-4cb5-92eb-b067d0767991")]
	[UmlTaggedValue("Eco.TableName", "OrderTable")]
    public class Order : ILoopBack {
        
        public class OrderListAdapter : ObjectListAdapter, IOrderList
		{
			public OrderListAdapter(IList source) : 
					base(source)
			{
			}
			public Order this[int index]
			{
				get
				{
					return ((Order)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Order value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Order value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Order value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Order value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Order value)
			{
				this.Adaptee.Remove(value);
			}
		}
        
        #region Autogenerated ECO code
        
        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
        
        public Order(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 4);
			public const int ShippingAddress = Eco_FirstMember;
			public const int Customer = (ShippingAddress + 1);
			public const int BillingAddress = (Customer + 1);
			public const int OrderItem = (BillingAddress + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
        
        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
        
        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
        
        #endregion Autogenerated ECO code
        
        public Order(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
        [UmlElement(Id="d49afdf8-1c2d-4669-b5ba-618959bb5c13", Index=Eco_LoopbackIndices.Customer)]
		public string Customer
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Customer)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Customer, ((object)(value)));
			}
		}
        [UmlElement(Id="8c0ca4a2-c969-418d-b5f1-c0efffece62e", Index=Eco_LoopbackIndices.ShippingAddress)]
		public string ShippingAddress
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShippingAddress)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShippingAddress, ((object)(value)));
			}
		}
        [UmlElement(Id="f5e2e598-15b3-474e-97da-7f29ee471ecb", Index=Eco_LoopbackIndices.BillingAddress)]
		public string BillingAddress
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.BillingAddress)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.BillingAddress, ((object)(value)));
			}
		}
        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.OrderItem, Id="f37ed6fa-c8f8-4c57-a71c-7257d498a0ca")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.Association_1), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		[UmlMetaAttribute("aggregation", AggregationKind.Composite)]
		public IOrderItemList OrderItem
		{
			get
			{
				return new OrderItem.OrderItemListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.OrderItem))));
			}
		}
    }

	[UmlCollection(typeof(Order))]
	public interface IOrderList : ICollection
	{
		#region ECO generated code
		Order this[int index]
		{
			get;
			set;
		}
		int Add(Order value);
		bool Contains(Order value);
		int IndexOf(Order value);
		void Insert(int index, Order value);
		void Remove(Order value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
    [UmlElement(Id="fefaad46-7422-40b1-8873-4dc3f41a1e7c")]
    public class OrderItem : ILoopBack {
        
        public class OrderItemListAdapter : ObjectListAdapter, IOrderItemList
		{
			public OrderItemListAdapter(IList source) : 
					base(source)
			{
			}
			public OrderItem this[int index]
			{
				get
				{
					return ((OrderItem)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(OrderItem value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(OrderItem value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(OrderItem value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, OrderItem value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(OrderItem value)
			{
				this.Adaptee.Remove(value);
			}
		}
        
        #region Autogenerated ECO code
        
        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
        
        public OrderItem(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 4);
			public const int Quantity = Eco_FirstMember;
			public const int Price = (Quantity + 1);
			public const int Product = (Price + 1);
			public const int Order = (Product + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
        
        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
        
        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
        
        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
        
        #endregion Autogenerated ECO code
        
        public OrderItem(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
        [UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Order, Id="2ea4773d-1771-497e-b907-e9f15e17e3d9")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.Association_1), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		[UmlTaggedValue("Eco.ColumnName", "OrderColumn")]
		public Order Order
		{
			get
			{
				return ((Order)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Order)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Order, ((object)(value)));
			}
		}
        [UmlElement(Id="da39ad0e-3808-41ee-b62d-e677de4def4f", Index=Eco_LoopbackIndices.Product)]
		public string Product
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Product)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Product, ((object)(value)));
			}
		}
        [UmlElement(Id="8a01609f-4cbf-4771-aa07-12225a545084", Index=Eco_LoopbackIndices.Quantity)]
		public int Quantity
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Quantity)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Quantity, ((object)(value)));
			}
		}
        [UmlElement(Id="caf13da2-901b-412b-af89-a0896c494869", Index=Eco_LoopbackIndices.Price)]
		public double Price
		{
			get
			{
				return ((double)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Price)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Price, ((object)(value)));
			}
		}
    }

	[UmlCollection(typeof(OrderItem))]
	public interface IOrderItemList : ICollection
	{
		#region ECO generated code
		OrderItem this[int index]
		{
			get;
			set;
		}
		int Add(OrderItem value);
		bool Contains(OrderItem value);
		int IndexOf(OrderItem value);
		void Insert(int index, OrderItem value);
		void Remove(OrderItem value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
}
